##
## Reciprocity / Sexual violence by other actors
##

##
## Enemies perpetrating SV
##

## ALL (state and non-state) ENEMIES (per conflict-year)

for(i in 1:nrow(Master)) { # cycle through every row
  # create cycle-specific variables for convenience 
  tmp_year <- Master[i,"year"]
  tmp_year_lag <- Master[i,"year"] - 1 # lag by one year
  tmp_conflict <- Master[i,"conflictid"]
  tmp_actor <- Master[i,"actor_type"]
  tmp_type <- Master[i, "type"]
  
  # SideA state actors (A and A2nd)
  if (tmp_actor == 1 | tmp_actor == 2 | tmp_actor == 6) {
    Master[i, "enemy_max_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
            (Master$actor_type == 3 | Master$actor_type == 4) ,],            # select all SideB enemies
      max(max_prev, na.rm = T)))                                             # select MAX-SV values
    
    Master[i, "enemy_median_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
            (Master$actor_type == 3 | Master$actor_type == 4) ,],            # select all SideB enemies
      max(median_prev, na.rm = T)))                                          # select MEDIAN-SV values

  # lag by one year
    Master[i, "enemy_max_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
            (Master$actor_type == 3 | Master$actor_type == 4) ,],            # select all SideB enemies
      max(max_prev, na.rm = T)))                                             # select MAX-SV values
    
    Master[i, "enemy_median_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
            (Master$actor_type == 3 | Master$actor_type == 4) ,],            # select all SideB enemies
      max(median_prev, na.rm = T)))                                          # select MEDIAN-SV values
  
  # SideB state actors (B (if interstate war) and B2nd)
  } else if (tmp_actor == 3 | tmp_actor == 4) {
    Master[i, "enemy_max_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &                 # per conflict year
            (Master$actor_type == 1 | Master$actor_type == 2 | Master$actor_type == 6) ,], # select all SideA enemies
      max(max_prev, na.rm = T)))                                                           # select MAX-SV values

    Master[i, "enemy_median_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &                 # per conflict year
            (Master$actor_type == 1 | Master$actor_type == 2 | Master$actor_type == 6) ,], # select all SideA enemies
      max(median_prev, na.rm = T)))                                                        # select MEDIAN-SV values

  # lag by one year
    Master[i, "enemy_max_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &                 # per conflict year
            (Master$actor_type == 1 | Master$actor_type == 2 | Master$actor_type == 6) ,], # select all SideA enemies
      max(max_prev, na.rm = T)))                                                           # select MAX-SV values
    
    Master[i, "enemy_median_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &                 # per conflict year
            (Master$actor_type == 1 | Master$actor_type == 2 | Master$actor_type == 6) ,], # select all SideA enemies
      max(median_prev, na.rm = T)))                                                        # select MEDIAN-SV values  
    
    # all others (missed cases?)
  } else {
    Master[i, "enemy_max_prev"] <- 0
    Master[i, "enemy_median_prev"] <- 0
    Master[i, "enemy_max_prev_lag"] <- 0
    Master[i, "enemy_median_prev_lag"] <- 0
  } # end elseif
} # end for()
Master$enemy_max_prev[is.infinite(Master$enemy_max_prev) | is.nan(Master$enemy_max_prev)] <- 0
Master$enemy_median_prev[is.infinite(Master$enemy_median_prev) | is.nan(Master$enemy_median_prev)] <- 0
Master$enemy_max_prev_lag[is.infinite(Master$enemy_max_prev_lag) | is.nan(Master$enemy_max_prev_lag)] <- 0
Master$enemy_median_prev_lag[is.infinite(Master$enemy_median_prev_lag) | is.nan(Master$enemy_median_prev_lag)] <- 0


## ONLY STATE ENEMIES (per conflict-year)

for(i in 1:nrow(Master)) { # cycle through every row
  # create cycle-specific variables for convenience 
  tmp_year <- Master[i,"year"]
  tmp_year_lag <- Master[i,"year"] - 1 # lag by one year
  tmp_conflict <- Master[i,"conflictid"]
  tmp_actor <- Master[i,"actor_type"]
  tmp_type <- Master[i, "type"]
  
  # SideA/A2nd/PGM actors
  if (tmp_actor == 1 | tmp_actor == 2 | tmp_actor == 6) {
    Master[i, "enemy_state_max_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 3 & Master$type == 2) | Master$actor_type == 4) ,],    # select STATE SideB enemies
      max(max_prev, na.rm = T)))                                             # select MAX-SV values
    
    Master[i, "enemy_state_median_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 3 & Master$type == 2) | Master$actor_type == 4) ,],    # select STATE SideB enemies
      max(median_prev, na.rm = T)))                                          # select MEDIAN-SV values
    
    # lag by one year
    Master[i, "enemy_state_max_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 3 & Master$type == 2) | Master$actor_type == 4) ,],    # select STATE SideB enemies
      max(max_prev, na.rm = T)))                                             # select MAX-SV values
    
    Master[i, "enemy_state_median_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 3 & Master$type == 2) | Master$actor_type == 4) ,],    # select STATE SideB enemies
      max(median_prev, na.rm = T)))                                          # select MEDIAN-SV values
    
    # SideB/B2nd actors
  } else if (tmp_actor == 3 | tmp_actor == 4) {
    Master[i, "enemy_state_max_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &                 # per conflict year
               (Master$actor_type == 1 | Master$actor_type == 2) ,], # select STATE SideA enemies
      max(max_prev, na.rm = T)))                                                           # select MAX-SV values
    
    Master[i, "enemy_state_median_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &                 # per conflict year
               (Master$actor_type == 1 | Master$actor_type == 2) ,], # select STATE SideA enemies
      max(median_prev, na.rm = T)))                                                        # select MEDIAN-SV values
    
    # lag by one year
    Master[i, "enemy_state_max_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &                 # per conflict year
               (Master$actor_type == 1 | Master$actor_type == 2) ,], # select STATE SideA enemies
      max(max_prev, na.rm = T)))                                                           # select MAX-SV values
    
    Master[i, "enemy_state_median_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &                 # per conflict year
               (Master$actor_type == 1 | Master$actor_type == 2) ,], # select STATE SideA enemies
      max(median_prev, na.rm = T)))                                                        # select MEDIAN-SV values  
    
    # all others (missed cases?)
  } else {
    Master[i, "enemy_state_max_prev"] <- 0
    Master[i, "enemy_state_median_prev"] <- 0
    Master[i, "enemy_state_max_prev_lag"] <- 0
    Master[i, "enemy_state_median_prev_lag"] <- 0
  } # end elseif
} # end for()
Master$enemy_state_max_prev[is.infinite(Master$enemy_state_max_prev) | is.nan(Master$enemy_state_max_prev)] <- 0
Master$enemy_state_median_prev[is.infinite(Master$enemy_state_median_prev) | is.nan(Master$enemy_state_median_prev)] <- 0
Master$enemy_state_max_prev_lag[is.infinite(Master$enemy_state_max_prev_lag) | is.nan(Master$enemy_state_max_prev_lag)] <- 0
Master$enemy_state_median_prev_lag[is.infinite(Master$enemy_state_median_prev_lag) | is.nan(Master$enemy_state_median_prev_lag)] <- 0


## ONLY NON-STATE ENEMIES (per conflict-year)

for(i in 1:nrow(Master)) { # cycle through every row
  # create cycle-specific variables for convenience 
  tmp_year <- Master[i,"year"]
  tmp_year_lag <- Master[i,"year"] - 1 # lag by one year
  tmp_conflict <- Master[i,"conflictid"]
  tmp_actor <- Master[i,"actor_type"]
  tmp_type <- Master[i, "type"]
  
  # SideA/A2nd/PGM actors
  if (tmp_actor == 1 | tmp_actor == 2 | tmp_actor == 6) {
    Master[i, "enemy_nonstate_max_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 3 & Master$type != 2)) ,],    # select NON-STATE SideB enemies
      max(max_prev, na.rm = T)))                                             # select MAX-SV values
    
    Master[i, "enemy_nonstate_median_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 3 & Master$type != 2)) ,],    # select NON-STATE SideB enemies
      max(median_prev, na.rm = T)))                                          # select MEDIAN-SV values
    
    # lag by one year
    Master[i, "enemy_nonstate_max_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 3 & Master$type != 2)) ,],    # select NON-STATE SideB enemies
      max(max_prev, na.rm = T)))                                             # select MAX-SV values
    
    Master[i, "enemy_nonstate_median_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 3 & Master$type != 2)) ,],    # select NON-STATE SideB enemies
      max(median_prev, na.rm = T)))                                          # select MEDIAN-SV values
    
    # SideB/B2nd actors
  } else if (tmp_actor == 3 | tmp_actor == 4) {
    Master[i, "enemy_nonstate_max_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &                 # per conflict year
               (Master$actor_type == 6) ,], # select NON-STATE SideA enemies
      max(max_prev, na.rm = T)))                                                           # select MAX-SV values
    
    Master[i, "enemy_nonstate_median_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &                 # per conflict year
               (Master$actor_type == 6) ,], # select NON-STATE SideA enemies
      max(median_prev, na.rm = T)))                                                        # select MEDIAN-SV values
    
    # lag by one year
    Master[i, "enemy_nonstate_max_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &                 # per conflict year
               (Master$actor_type == 6) ,], # select NON-STATE SideA enemies
      max(max_prev, na.rm = T)))                                                           # select MAX-SV values
    
    Master[i, "enemy_nonstate_median_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &                 # per conflict year
               (Master$actor_type == 6) ,], # select NON-STATE SideA enemies
      max(median_prev, na.rm = T)))                                                        # select MEDIAN-SV values  
    
    # all others (missed cases?)
  } else {
    Master[i, "enemy_nonstate_max_prev"] <- 0
    Master[i, "enemy_nonstate_median_prev"] <- 0
    Master[i, "enemy_nonstate_max_prev_lag"] <- 0
    Master[i, "enemy_nonstate_median_prev_lag"] <- 0
  } # end elseif
} # end for()
Master$enemy_nonstate_max_prev[is.infinite(Master$enemy_nonstate_max_prev) | is.nan(Master$enemy_nonstate_max_prev)] <- 0
Master$enemy_nonstate_median_prev[is.infinite(Master$enemy_nonstate_median_prev) | is.nan(Master$enemy_nonstate_median_prev)] <- 0
Master$enemy_nonstate_max_prev_lag[is.infinite(Master$enemy_nonstate_max_prev_lag) | is.nan(Master$enemy_nonstate_max_prev_lag)] <- 0
Master$enemy_nonstate_median_prev_lag[is.infinite(Master$enemy_nonstate_median_prev_lag) | is.nan(Master$enemy_nonstate_median_prev_lag)] <- 0


##
## Ally perpetrating SV
##

## ALL (state and non-state) ALLIES (per conflict-year)

for(i in 1:nrow(Master)) { # cycle through every row
  # create cycle-specific variables for convenience 
  tmp_year <- Master[i,"year"]
  tmp_year_lag <- Master[i,"year"] - 1 # lag by one year
  tmp_conflict <- Master[i,"conflictid"]
  tmp_actor <- Master[i,"actor_type"]
  tmp_actorid <- Master[i,"actorid"]
  tmp_type <- Master[i, "type"]
  
  # SideA state actors (A and A2nd)
  if (tmp_actor == 1 | tmp_actor == 2 | tmp_actor == 6) {
    Master[i, "ally_max_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
           ((Master$actor_type == 1 | Master$actor_type == 2 | Master$actor_type == 6) & # select all SideA allies
             Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(max_prev, na.rm = T)))                                             # select MAX-SV values
    
    Master[i, "ally_median_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
           ((Master$actor_type == 1 | Master$actor_type == 2 | Master$actor_type == 6) &  # select all SideA allies
             Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(median_prev, na.rm = T)))                                             # select MEDIAN-SV values
    
    # lag by one year
    Master[i, "ally_max_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 1 | Master$actor_type == 2 | Master$actor_type == 6) & # select all SideA allies
                  Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(max_prev, na.rm = T)))                                             # select MAX-SV values
    
    Master[i, "ally_median_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 1 | Master$actor_type == 2 | Master$actor_type == 6) &  # select all SideA allies
                  Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(median_prev, na.rm = T)))                                             # select MEDIAN-SV values
      
  # SideB state actors (B (if interstate war) and B2nd)
  } else if (tmp_actor == 3 | tmp_actor == 4) {
    Master[i, "ally_max_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 3 | Master$actor_type == 4) & # select all SideA allies
                  Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(max_prev, na.rm = T)))                                             # select MAX-SV values
    
    Master[i, "ally_median_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 3 | Master$actor_type == 4) &  # select all SideA allies
                  Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(median_prev, na.rm = T)))                                             # select MEDIAN-SV values
    
    # lag by one year
    Master[i, "ally_max_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 3 | Master$actor_type == 4) & # select all SideA allies
                  Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(max_prev, na.rm = T)))                                             # select MAX-SV values
    
    Master[i, "ally_median_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 3 | Master$actor_type == 4) &  # select all SideA allies
                  Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(median_prev, na.rm = T)))                                             # select MEDIAN-SV values
      
    # all others (missed cases?)
  } else {
    Master[i, "ally_max_prev"] <- 0
    Master[i, "ally_median_prev"] <- 0
    Master[i, "ally_max_prev_lag"] <- 0
    Master[i, "ally_median_prev_lag"] <- 0
  } # end elseif
} # end for()
Master$ally_max_prev[is.infinite(Master$ally_max_prev) | is.nan(Master$ally_max_prev)] <- 0
Master$ally_median_prev[is.infinite(Master$ally_median_prev) | is.nan(Master$ally_median_prev)] <- 0
Master$ally_max_prev_lag[is.infinite(Master$ally_max_prev_lag) | is.nan(Master$ally_max_prev_lag)] <- 0
Master$ally_median_prev_lag[is.infinite(Master$ally_median_prev_lag) | is.nan(Master$ally_median_prev_lag)] <- 0



## ONLY STATE ALLIES (per conflict-year)

for(i in 1:nrow(Master)) { # cycle through every row
  # create cycle-specific variables for convenience 
  tmp_year <- Master[i,"year"]
  tmp_year_lag <- Master[i,"year"] - 1 # lag by one year
  tmp_conflict <- Master[i,"conflictid"]
  tmp_actor <- Master[i,"actor_type"]
  tmp_actorid <- Master[i,"actorid"]
  tmp_type <- Master[i, "type"]
  
  # SideA state actors (A and A2nd)
  if (tmp_actor == 1 | tmp_actor == 2 | tmp_actor == 6) {
    Master[i, "ally_state_max_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 1 | Master$actor_type == 2) & # select all SideA allies
                  Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(max_prev, na.rm = T)))                                             # select MAX-SV values
    
    Master[i, "ally_state_median_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 1 | Master$actor_type == 2) &  # select all SideA allies
                  Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(median_prev, na.rm = T)))                                             # select MEDIAN-SV values
    
    # lag by one year
    Master[i, "ally_state_max_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 1 | Master$actor_type == 2) & # select all SideA allies
                 Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(max_prev, na.rm = T)))                                             # select MAX-SV values
    
    Master[i, "ally_state_median_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
               ((Master$actor_type == 1 | Master$actor_type == 2) &  # select all SideA allies
                  Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(median_prev, na.rm = T)))                                             # select MEDIAN-SV values
    
    # SideB state actors (B (if interstate war) and B2nd)
  } else if (tmp_actor == 3 | tmp_actor == 4) {
    Master[i, "ally_state_max_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
               (((Master$actor_type == 3 & Master$type == 2) | Master$actor_type == 4) & # select all SideA allies
                  Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(max_prev, na.rm = T)))                                             # select MAX-SV values
    
    Master[i, "ally_state_median_prev"] <- as.numeric(summarize(
      Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
               (((Master$actor_type == 3 & Master$type == 2) | Master$actor_type == 4) &  # select all SideA allies
                  Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(median_prev, na.rm = T)))                                             # select MEDIAN-SV values
    
    # lag by one year
    Master[i, "ally_state_max_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
               (((Master$actor_type == 3 & Master$type == 2) | Master$actor_type == 4) & # select all SideA allies
                  Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(max_prev, na.rm = T)))                                             # select MAX-SV values
    
    Master[i, "ally_state_median_prev_lag"] <- as.numeric(summarize(
      Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
               (((Master$actor_type == 3 & Master$type == 2) | Master$actor_type == 4) &  # select all SideA allies
                  Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
      max(median_prev, na.rm = T)))                                             # select MEDIAN-SV values
    
    # all others (missed cases?)
  } else {
    Master[i, "ally_state_max_prev"] <- 0
    Master[i, "ally_state_median_prev"] <- 0
    Master[i, "ally_state_max_prev_lag"] <- 0
    Master[i, "ally_state_median_prev_lag"] <- 0
  } # end elseif
} # end for()
Master$ally_state_max_prev[is.infinite(Master$ally_state_max_prev) | is.nan(Master$ally_state_max_prev)] <- 0
Master$ally_state_median_prev[is.infinite(Master$ally_state_median_prev) | is.nan(Master$ally_state_median_prev)] <- 0
Master$ally_state_max_prev_lag[is.infinite(Master$ally_state_max_prev_lag) | is.nan(Master$ally_state_max_prev_lag)] <- 0
Master$ally_state_median_prev_lag[is.infinite(Master$ally_state_median_prev_lag) | is.nan(Master$ally_state_median_prev_lag)] <- 0


## ONLY NON-STATE ALLIES (per conflict-year)

for(i in 1:nrow(Master)) { # cycle through every row
  # create cycle-specific variables for convenience 
  tmp_year <- Master[i,"year"]
  tmp_year_lag <- Master[i,"year"] - 1 # lag by one year
  tmp_conflict <- Master[i,"conflictid"]
  tmp_actor <- Master[i,"actor_type"]
  tmp_actorid <- Master[i,"actorid"]
  tmp_type <- Master[i, "type"]
  
  # SideA state actors (A and A2nd)
if (tmp_actor == 1 | tmp_actor == 2 | tmp_actor == 6) {
  Master[i, "ally_nonstate_max_prev"] <- as.numeric(summarize(
    Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
             (Master$actor_type == 6 & # select all SideA allies
                Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
    max(max_prev, na.rm = T)))                                             # select MAX-SV values
  
  Master[i, "ally_nonstate_median_prev"] <- as.numeric(summarize(
    Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
             (Master$actor_type == 6 &  # select all SideA allies
                Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
    max(median_prev, na.rm = T)))                                             # select MEDIAN-SV values
  
  # lag by one year
  Master[i, "ally_nonstate_max_prev_lag"] <- as.numeric(summarize(
    Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
             (Master$actor_type == 6 & # select all SideA allies
                Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
    max(max_prev, na.rm = T)))                                             # select MAX-SV values
  
  Master[i, "ally_nonstate_median_prev_lag"] <- as.numeric(summarize(
    Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
             (Master$actor_type == 6 &  # select all SideA allies
                Master$actorid != tmp_actorid) ,],            # (but make sure that current actor i is excluded)
    max(median_prev, na.rm = T)))                                             # select MEDIAN-SV values
    
# SideB state actors (B (if interstate war) and B2nd)
} else if (tmp_actor == 3 | tmp_actor == 4) {
  Master[i, "ally_nonstate_max_prev"] <- as.numeric(summarize(
    Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
             ((Master$actor_type == 3 & Master$type != 2 & # select all SideA allies
                Master$actorid != tmp_actorid)) ,],            # (but make sure that current actor i is excluded)
    max(max_prev, na.rm = T)))                                             # select MAX-SV values
  
  Master[i, "ally_nonstate_median_prev"] <- as.numeric(summarize(
    Master[Master$year == tmp_year & Master$conflictid == tmp_conflict &   # per conflict-year
             ((Master$actor_type == 3 & Master$type != 2 &  # select all SideA allies
                Master$actorid != tmp_actorid)) ,],            # (but make sure that current actor i is excluded)
    max(median_prev, na.rm = T)))                                             # select MEDIAN-SV values
  
  # lag by one year
  Master[i, "ally_nonstate_max_prev_lag"] <- as.numeric(summarize(
    Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
             ((Master$actor_type == 3 & Master$type != 2 & # select all SideA allies
                Master$actorid != tmp_actorid)) ,],            # (but make sure that current actor i is excluded)
    max(max_prev, na.rm = T)))                                             # select MAX-SV values
  
  Master[i, "ally_nonstate_median_prev_lag"] <- as.numeric(summarize(
    Master[Master$year == tmp_year_lag & Master$conflictid == tmp_conflict &   # per conflict-year
             ((Master$actor_type == 3 & Master$type != 2 &  # select all SideA allies
                Master$actorid != tmp_actorid)) ,],            # (but make sure that current actor i is excluded)
    max(median_prev, na.rm = T)))                                             # select MEDIAN-SV values
  
    # all others (missed cases?)
  } else {
    Master[i, "ally_nonstate_max_prev"] <- 0
    Master[i, "ally_nonstate_median_prev"] <- 0
    Master[i, "ally_nonstate_max_prev_lag"] <- 0
    Master[i, "ally_nonstate_median_prev_lag"] <- 0
  } # end elseif
} # end for()
Master$ally_nonstate_max_prev[is.infinite(Master$ally_nonstate_max_prev) | is.nan(Master$ally_nonstate_max_prev)] <- 0
Master$ally_nonstate_median_prev[is.infinite(Master$ally_nonstate_median_prev) | is.nan(Master$ally_nonstate_median_prev)] <- 0
Master$ally_nonstate_max_prev_lag[is.infinite(Master$ally_nonstate_max_prev_lag) | is.nan(Master$ally_nonstate_max_prev_lag)] <- 0
Master$ally_nonstate_median_prev_lag[is.infinite(Master$ally_nonstate_median_prev_lag) | is.nan(Master$ally_nonstate_median_prev_lag)] <- 0

# Clean up
rm(i, tmp_actor, tmp_actorid, tmp_conflict, tmp_type, tmp_year, tmp_year_lag)